<!-- ============================================
     RESPONSIVE HEADER WITH WELCOME, CONTACT STRIP & STICKY NAV
     ============================================ -->

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    /* WELCOME HEADER SECTION */
    .welcome-header {
        background: linear-gradient(135deg, #109c3d 0%, #0d7a30 100%);
        color: white;
        padding: 12px 0;
        font-size: 14px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }

    .welcome-header-content {
        max-width: 1400px;
        margin: 0 auto;
        padding: 0 20px;
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 40px;
    }

    .welcome-header-text {
        text-align: center;
        font-weight: 500;
        letter-spacing: 0.5px;
    }

    /* CONTACT STRIP SECTION */
    .contact-strip {
        background: #f8f9fa;
        padding: 15px 0;
        border-bottom: 1px solid #e9ecef;
    }

    .contact-strip-content {
        max-width: 1400px;
        margin: 0 auto;
        padding: 0 20px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 15px;
    }

    .contact-item {
        display: flex;
        align-items: center;
        gap: 8px;
        color: #333;
        font-size: 13px;
        font-weight: 500;
    }

    .contact-item i {
        color: #109c3d;
        font-size: 15px;
        min-width: 18px;
    }

    .contact-item a {
        color: #333;
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .contact-item a:hover {
        color: #109c3d;
    }

    .social-links {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .social-links a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 28px;
        height: 28px;
        background: white;
        border: 1px solid #ddd;
        border-radius: 4px;
        color: #109c3d;
        font-size: 13px;
        transition: all 0.3s ease;
    }

    .social-links a:hover {
        background: #109c3d;
        color: white;
        border-color: #109c3d;
    }

    /* STICKY HEADER */
    .main-header {
        background: white;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        position: relative;
        z-index: 999;
        transition: all 0.3s ease;
    }

    .main-header.sticky {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
        z-index: 1000;
    }

    .header-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: 0 20px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        height: 70px;
    }

    .logo {
        flex-shrink: 0;
    }

    .logo a {
        display: flex;
        align-items: center;
        text-decoration: none;
        color: #109c3d;
        font-weight: 700;
        font-size: 20px;
        gap: 8px;
    }

    .logo img {
        max-height: 45px;
        width: auto;
    }

    .logo i {
        font-size: 28px;
    }

    /* NAVIGATION MENU */
    .nav-menu {
        display: flex;
        align-items: center;
        gap: 40px;
        list-style: none;
        margin: 0;
        padding: 0;
        flex: 1;
    }

    .nav-item {
        position: relative;
    }

    .nav-item > a {
        color: #333;
        text-decoration: none;
        font-weight: 500;
        font-size: 15px;
        transition: color 0.3s ease;
        display: flex;
        align-items: center;
        gap: 5px;
        padding: 5px 0;
    }

    .nav-item > a:hover {
        color: #109c3d;
    }

    .nav-item .dropdown-menu {
        position: absolute;
        top: 100%;
        left: 0;
        background: white;
        border-radius: 6px;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
        min-width: 180px;
        list-style: none;
        margin: 10px 0 0 0;
        padding: 8px 0;
        opacity: 0;
        visibility: hidden;
        transform: translateY(-10px);
        transition: all 0.3s ease;
    }

    .nav-item:hover .dropdown-menu {
        opacity: 1;
        visibility: visible;
        transform: translateY(0);
    }

    .dropdown-menu li a {
        display: block;
        padding: 10px 20px;
        color: #333;
        text-decoration: none;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .dropdown-menu li a:hover {
        background: #f0f0f0;
        color: #109c3d;
        padding-left: 25px;
    }

    /* HEADER ACTIONS */
    .header-actions {
        display: flex;
        align-items: center;
        gap: 20px;
        flex-shrink: 0;
    }

    .auth-buttons {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .auth-btn {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 8px 16px;
        border-radius: 6px;
        text-decoration: none;
        font-weight: 600;
        font-size: 14px;
        transition: all 0.3s ease;
        border: 2px solid #109c3d;
    }

    .login-btn {
        color: #109c3d;
        background: transparent;
    }

    .login-btn:hover {
        background: #109c3d;
        color: white;
    }

    .register-btn {
        color: white;
        background: #109c3d;
    }

    .register-btn:hover {
        background: #0d7a30;
        border-color: #0d7a30;
    }

    /* USER PROFILE DROPDOWN */
    .user-profile {
        position: relative;
    }

    .profile-toggle {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 8px 12px;
        background: rgba(16, 156, 61, 0.08);
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
        border: none;
        user-select: none;
    }

    .profile-toggle:hover {
        background: rgba(16, 156, 61, 0.15);
    }

    .profile-avatar {
        width: 35px;
        height: 35px;
        border-radius: 50%;
        background: #109c3d;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 700;
        font-size: 14px;
    }

    .profile-info {
        text-align: left;
        display: none;
    }

    .profile-info .name {
        font-weight: 600;
        color: #0f172a;
        font-size: 14px;
    }

    .profile-info .role {
        font-size: 12px;
        color: #64748b;
    }

    .dropdown-icon {
        font-size: 12px;
        color: #109c3d;
        transition: transform 0.3s ease;
    }

    .profile-dropdown {
        position: absolute;
        top: 100%;
        right: 0;
        background: white;
        border-radius: 8px;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.15);
        min-width: 220px;
        margin-top: 8px;
        opacity: 0;
        visibility: hidden;
        transform: translateY(-10px);
        transition: all 0.3s ease;
        z-index: 1001;
        overflow: hidden;
    }

    .profile-dropdown.active {
        opacity: 1;
        visibility: visible;
        transform: translateY(0);
    }

    .profile-dropdown a,
    .profile-dropdown div {
        display: flex;
        align-items: center;
        padding: 12px 16px;
        color: #0f172a;
        text-decoration: none;
        font-size: 14px;
        transition: all 0.3s ease;
        border-bottom: 1px solid #f0f0f0;
    }

    .profile-dropdown a:last-child {
        border-bottom: none;
    }

    .profile-dropdown a i {
        margin-right: 10px;
        width: 16px;
        text-align: center;
        color: #109c3d;
    }

    .profile-dropdown a:hover {
        background: #f8fbff;
        color: #109c3d;
        padding-left: 20px;
    }

    /* MOBILE MENU TOGGLE */
    .mobile-toggle {
        display: none;
        background: none;
        border: none;
        font-size: 24px;
        color: #333;
        cursor: pointer;
        padding: 0;
    }

    .mobile-toggle:focus {
        outline: none;
    }

    /* MOBILE MENU */
    .mobile-menu {
        display: none;
        position: fixed;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100vh;
        background: white;
        z-index: 999;
        transition: left 0.3s ease;
        overflow-y: auto;
        padding-top: 60px;
    }

    .mobile-menu.active {
        left: 0;
    }

    .mobile-menu-close {
        position: absolute;
        top: 15px;
        right: 20px;
        background: none;
        border: none;
        font-size: 28px;
        color: #333;
        cursor: pointer;
        z-index: 1001;
    }

    .mobile-menu ul {
        list-style: none;
        padding: 20px 0;
    }

    .mobile-menu li {
        border-bottom: 1px solid #f0f0f0;
    }

    .mobile-menu a {
        display: block;
        padding: 15px 20px;
        color: #333;
        text-decoration: none;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .mobile-menu a:hover {
        background: #f8f9fa;
        color: #109c3d;
        padding-left: 25px;
    }

    .mobile-menu .submenu {
        display: none;
        background: #f8f9fa;
    }

    .mobile-menu .submenu.active {
        display: block;
    }

    .mobile-menu .submenu a {
        padding-left: 40px;
        font-size: 14px;
    }

    /* RESPONSIVE DESIGN */
    @media (max-width: 1024px) {
        .nav-menu {
            gap: 25px;
        }

        .nav-item > a {
            font-size: 14px;
        }

        .header-container {
            height: 65px;
        }
    }

    @media (max-width: 768px) {
        .welcome-header {
            padding: 10px 0;
            font-size: 12px;
        }

        .welcome-header-content {
            min-height: 35px;
        }

        .contact-strip-content {
            justify-content: center;
            flex-direction: column;
        }

        .contact-item {
            font-size: 12px;
        }

        .nav-menu {
            display: none;
        }

        .mobile-toggle {
            display: block;
        }

        .mobile-menu {
            display: block;
        }

        .profile-info {
            display: none;
        }

        .auth-buttons {
            gap: 8px;
        }

        .auth-btn {
            padding: 6px 12px;
            font-size: 12px;
            gap: 4px;
        }

        .header-container {
            height: 60px;
        }

        .logo a {
            font-size: 18px;
        }

        .logo img {
            max-height: 40px;
        }

        .profile-dropdown {
            position: fixed;
            right: 0;
            top: auto;
            left: auto;
            min-width: 180px;
            border-radius: 8px 0 0 8px;
        }
    }

    @media (max-width: 480px) {
        .welcome-header-text {
            font-size: 11px;
        }

        .contact-item {
            font-size: 11px;
        }

        .social-links a {
            width: 24px;
            height: 24px;
            font-size: 12px;
        }

        .header-container {
            height: 55px;
            gap: 10px;
        }

        .logo a {
            font-size: 16px;
        }

        .logo img {
            max-height: 35px;
        }

        .header-actions {
            gap: 12px;
        }

        .auth-btn {
            padding: 5px 10px;
            font-size: 11px;
        }

        .auth-btn span {
            display: none;
        }

        .profile-avatar {
            width: 30px;
            height: 30px;
            font-size: 12px;
        }

        .profile-toggle {
            padding: 6px 8px;
        }

        .contact-item i {
            font-size: 12px;
        }
    }
</style>

<!-- WELCOME HEADER -->
<div class="welcome-header">
    <div class="welcome-header-content">
        <div class="welcome-header-text">
            <i class="fas fa-check-circle"></i> Welcome to Our Cleaning Service - Professional & Reliable Solutions
        </div>
    </div>
</div>

<!-- CONTACT STRIP -->
<div class="contact-strip">
    <div class="contact-strip-content">
        <div class="contact-item">
            <i class="fas fa-envelope"></i>
            <a href="mailto:info@example.com">info@example.com</a>
        </div>
        <div class="contact-item">
            <i class="fas fa-phone"></i>
            <a href="tel:+1234567890">+1 (234) 567-890</a>
        </div>
        <div class="contact-item">
            <i class="fas fa-clock"></i>
            <span>Monday - Friday 8:00 AM - 6:00 PM</span>
        </div>
        <div class="social-links">
            <a href="https://facebook.com" title="Facebook" target="_blank"><i class="fab fa-facebook-f"></i></a>
            <a href="https://linkedin.com" title="LinkedIn" target="_blank"><i class="fab fa-linkedin-in"></i></a>
            <a href="https://instagram.com" title="Instagram" target="_blank"><i class="fab fa-instagram"></i></a>
        </div>
    </div>
</div>

<!-- STICKY MAIN HEADER -->
<header class="main-header" id="main-header">
    <div class="header-container">
        <!-- LOGO -->
        <div class="logo">
            <a href="index.php">
                <i class="fas fa-sparkles"></i>
                <span>CleanPro</span>
            </a>
        </div>

        <!-- NAVIGATION MENU (Desktop) -->
        <nav class="nav-menu">
            <li class="nav-item">
                <a href="index.php">Home</a>
            </li>
            <li class="nav-item">
                <a href="about.php">About <i class="fas fa-chevron-down" style="font-size: 10px;"></i></a>
                <ul class="dropdown-menu">
                    <li><a href="team.php">Team</a></li>
                    <li><a href="blog.php">Blog</a></li>
                </ul>
            </li>
            <li class="nav-item">
                <a href="service.php">Services</a>
            </li>
            <li class="nav-item">
                <a href="blog.php">Blog</a>
            </li>
            <li class="nav-item">
                <a href="portfolio.php">Gallery</a>
            </li>
            <li class="nav-item">
                <a href="contact.php">Contact</a>
            </li>
        </nav>

        <!-- HEADER ACTIONS -->
        <div class="header-actions">
            <?php if (isset($_SESSION['user_id'])): ?>
                <div class="user-profile">
                    <button class="profile-toggle" id="profile-toggle">
                        <div class="profile-avatar">
                            <?php 
                                $displayName = $_SESSION['admin_name'] ?? $_SESSION['name'] ?? 'User';
                                echo strtoupper(substr($displayName, 0, 1)); 
                            ?>
                        </div>
                        <div class="profile-info">
                            <div class="name"><?php echo htmlspecialchars($displayName); ?></div>
                            <div class="role"><?php echo ucfirst($_SESSION['user_type']); ?></div>
                        </div>
                        <i class="fas fa-chevron-down dropdown-icon"></i>
                    </button>
                    <div class="profile-dropdown" id="profile-dropdown">
                        <div style="border-bottom: 1px solid #f0f0f0;">
                            <strong><?php echo htmlspecialchars($displayName); ?></strong>
                        </div>
                        <a href="<?php echo $_SESSION['user_type'] === 'admin' ? 'admin-dashboard.php' : 'customer-dashboard.php'; ?>">
                            <i class="fas fa-th-large"></i>
                            <span>Dashboard</span>
                        </a>
                        <a href="logout.php">
                            <i class="fas fa-sign-out-alt"></i>
                            <span>Logout</span>
                        </a>
                    </div>
                </div>
            <?php else: ?>
                <div class="auth-buttons">
                    <a href="login.php" class="auth-btn login-btn">
                        <i class="fas fa-sign-in-alt"></i>
                        <span>Login</span>
                    </a>
                    <a href="register.php" class="auth-btn register-btn">
                        <i class="fas fa-user-plus"></i>
                        <span>Register</span>
                    </a>
                </div>
            <?php endif; ?>
        </div>

        <!-- MOBILE MENU TOGGLE -->
        <button class="mobile-toggle" id="mobile-toggle">
            <i class="fas fa-bars"></i>
        </button>
    </div>
</header>

<!-- MOBILE MENU -->
<div class="mobile-menu" id="mobile-menu">
    <button class="mobile-menu-close" id="mobile-menu-close">
        <i class="fas fa-times"></i>
    </button>
    <ul>
        <li><a href="index.php">Home</a></li>
        <li>
            <a href="about.php" onclick="toggleSubmenu(event, this)">About <i class="fas fa-chevron-right" style="font-size: 12px; margin-left: 5px;"></i></a>
            <ul class="submenu">
                <li><a href="team.php">Team</a></li>
                <li><a href="blog.php">Blog</a></li>
            </ul>
        </li>
        <li><a href="service.php">Services</a></li>
        <li><a href="blog.php">Blog</a></li>
        <li><a href="portfolio.php">Gallery</a></li>
        <li><a href="contact.php">Contact</a></li>
    </ul>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const header = document.getElementById('main-header');
    const mobileToggle = document.getElementById('mobile-toggle');
    const mobileMenu = document.getElementById('mobile-menu');
    const mobileMenuClose = document.getElementById('mobile-menu-close');
    const profileToggle = document.getElementById('profile-toggle');
    const profileDropdown = document.getElementById('profile-dropdown');

    // Sticky header on scroll
    window.addEventListener('scroll', function() {
        if (window.scrollY > 50) {
            header.classList.add('sticky');
        } else {
            header.classList.remove('sticky');
        }
    });

    // Mobile menu toggle
    mobileToggle.addEventListener('click', function() {
        mobileMenu.classList.add('active');
    });

    mobileMenuClose.addEventListener('click', function() {
        mobileMenu.classList.remove('active');
    });

    // Close mobile menu when clicking links
    document.querySelectorAll('.mobile-menu a').forEach(link => {
        link.addEventListener('click', function(e) {
            if (!this.onclick || !this.onclick.toString().includes('toggleSubmenu')) {
                mobileMenu.classList.remove('active');
            }
        });
    });

    // Profile dropdown toggle
    if (profileToggle) {
        profileToggle.addEventListener('click', function(e) {
            e.stopPropagation();
            profileDropdown.classList.toggle('active');
        });

        document.addEventListener('click', function(e) {
            if (!profileToggle.contains(e.target) && !profileDropdown.contains(e.target)) {
                profileDropdown.classList.remove('active');
            }
        });
    }

    // Close profile dropdown when clicking a link
    document.querySelectorAll('.profile-dropdown a').forEach(link => {
        link.addEventListener('click', function() {
            profileDropdown.classList.remove('active');
        });
    });
});

// Toggle submenu in mobile menu
function toggleSubmenu(e, element) {
    e.preventDefault();
    const submenu = element.nextElementSibling;
    if (submenu && submenu.classList.contains('submenu')) {
        submenu.classList.toggle('active');
    }
}
</script>
